------------------------------------------------------------------------
-- Event:        Delphi Day 2018, Piacenza, June 06 2018               -
--               https://www.delphiday.it/                             -
-- Seminary:     How to write high performance queries in T-SQL        -
-- Demo:         Execution Plan - Warnings                             -
-- Author:       Sergio Govoni                                         -
-- Notes:        --                                                    -
------------------------------------------------------------------------

USE [AdventureWorks2017];
GO


-- Type conversion
SELECT
  h.SalesOrderNumber
  ,SUM(d.LineTotal) AS LinesTotal
FROM
  Sales.SalesOrderHeader AS h
JOIN
  Sales.SalesOrderDetail AS d
  ON h.SalesOrderID=d.SalesOrderID
WHERE
  (h.OrderDate >= '20071001')
GROUP BY
  h.SalesOrderNumber
ORDER BY
  LinesTotal DESC;
GO


-- No Join Predicate
SELECT
  *
FROM
  Production.TransactionHistory AS th
  ,Production.Product AS p;
GO



-- Sort Warnings
-- Cardinality estimation
-- ActualRows <> EstimateRows
SELECT
  *
FROM
  Purchasing.PurchaseOrderDetail AS pod
WHERE
  (pod.ReceivedQty >= pod.OrderQty)
ORDER BY
  pod.RejectedQty DESC;
GO



-- Warning #3
-- UnmatchedIndexes

EXEC sp_helpindex 'dbo.myOrderHeader';
GO

DECLARE @DateTo VARCHAR(8) = '20150128';

SELECT
  DeliveryDate
  ,OrderID
  ,OrderDate
FROM
  dbo.myOrderHeader
WHERE
  --(DeliveryDate BETWEEN '20150127' AND '20150128')
  (DeliveryDate BETWEEN '20150127' AND @DateTo)
  AND (DeliveryNote IS NOT NULL);
GO